/**
 * WordPress dependencies
 */
import {
	Path,
	SVG,
} from '@wordpress/components';

/**
 * HeadingLevelIcon props.
 *
 * @typedef WPHeadingLevelIconProps
 * @property {number}   level     The heading level to show an icon for.
 * @property {?boolean} isPressed Whether or not the icon should appear pressed; default: false.
 */

/**
 * Heading level icon.
 *
 * @param {WPHeadingLevelIconProps} props Component props.
 * @return {JSX.Element} The heading level icon.
 */
export function TagNameIcon( { level } ) {
	const levelToPath = {
		h1: 'M9 5h2v10H9v-4H5v4H3V5h2v4h4V5zm6.6 0c-.6.9-1.5 1.7-2.6 2v1h2v7h2V5h-1.4z',
		h2: 'M7 5h2v10H7v-4H3v4H1V5h2v4h4V5zm8 8c.5-.4.6-.6 1.1-1.1.4-.4.8-.8 1.2-1.3.3-.4.6-.8.9-1.3.2-.4.3-.8.3-1.3 0-.4-.1-.9-.3-1.3-.2-.4-.4-.7-.8-1-.3-.3-.7-.5-1.2-.6-.5-.2-1-.2-1.5-.2-.4 0-.7 0-1.1.1-.3.1-.7.2-1 .3-.3.1-.6.3-.9.5-.3.2-.6.4-.8.7l1.2 1.2c.3-.3.6-.5 1-.7.4-.2.7-.3 1.2-.3s.9.1 1.3.4c.3.3.5.7.5 1.1 0 .4-.1.8-.4 1.1-.3.5-.6.9-1 1.2-.4.4-1 .9-1.6 1.4-.6.5-1.4 1.1-2.2 1.6V15h8v-2H15z',
		h3: 'M12.1 12.2c.4.3.8.5 1.2.7.4.2.9.3 1.4.3.5 0 1-.1 1.4-.3.3-.1.5-.5.5-.8 0-.2 0-.4-.1-.6-.1-.2-.3-.3-.5-.4-.3-.1-.7-.2-1-.3-.5-.1-1-.1-1.5-.1V9.1c.7.1 1.5-.1 2.2-.4.4-.2.6-.5.6-.9 0-.3-.1-.6-.4-.8-.3-.2-.7-.3-1.1-.3-.4 0-.8.1-1.1.3-.4.2-.7.4-1.1.6l-1.2-1.4c.5-.4 1.1-.7 1.6-.9.5-.2 1.2-.3 1.8-.3.5 0 1 .1 1.6.2.4.1.8.3 1.2.5.3.2.6.5.8.8.2.3.3.7.3 1.1 0 .5-.2.9-.5 1.3-.4.4-.9.7-1.5.9v.1c.6.1 1.2.4 1.6.8.4.4.7.9.7 1.5 0 .4-.1.8-.3 1.2-.2.4-.5.7-.9.9-.4.3-.9.4-1.3.5-.5.1-1 .2-1.6.2-.8 0-1.6-.1-2.3-.4-.6-.2-1.1-.6-1.6-1l1.1-1.4zM7 9H3V5H1v10h2v-4h4v4h2V5H7v4z',
		h4: 'M9 15H7v-4H3v4H1V5h2v4h4V5h2v10zm10-2h-1v2h-2v-2h-5v-2l4-6h3v6h1v2zm-3-2V7l-2.8 4H16z',
		h5: 'M12.1 12.2c.4.3.7.5 1.1.7.4.2.9.3 1.3.3.5 0 1-.1 1.4-.4.4-.3.6-.7.6-1.1 0-.4-.2-.9-.6-1.1-.4-.3-.9-.4-1.4-.4H14c-.1 0-.3 0-.4.1l-.4.1-.5.2-1-.6.3-5h6.4v1.9h-4.3L14 8.8c.2-.1.5-.1.7-.2.2 0 .5-.1.7-.1.5 0 .9.1 1.4.2.4.1.8.3 1.1.6.3.2.6.6.8.9.2.4.3.9.3 1.4 0 .5-.1 1-.3 1.4-.2.4-.5.8-.9 1.1-.4.3-.8.5-1.3.7-.5.2-1 .3-1.5.3-.8 0-1.6-.1-2.3-.4-.6-.2-1.1-.6-1.6-1-.1-.1 1-1.5 1-1.5zM9 15H7v-4H3v4H1V5h2v4h4V5h2v10z',
		h6: 'M9 15H7v-4H3v4H1V5h2v4h4V5h2v10zm8.6-7.5c-.2-.2-.5-.4-.8-.5-.6-.2-1.3-.2-1.9 0-.3.1-.6.3-.8.5l-.6.9c-.2.5-.2.9-.2 1.4.4-.3.8-.6 1.2-.8.4-.2.8-.3 1.3-.3.4 0 .8 0 1.2.2.4.1.7.3 1 .6.3.3.5.6.7.9.2.4.3.8.3 1.3s-.1.9-.3 1.4c-.2.4-.5.7-.8 1-.4.3-.8.5-1.2.6-1 .3-2 .3-3 0-.5-.2-1-.5-1.4-.9-.4-.4-.8-.9-1-1.5-.2-.6-.3-1.3-.3-2.1s.1-1.6.4-2.3c.2-.6.6-1.2 1-1.6.4-.4.9-.7 1.4-.9.6-.3 1.1-.4 1.7-.4.7 0 1.4.1 2 .3.5.2 1 .5 1.4.8 0 .1-1.3 1.4-1.3 1.4zm-2.4 5.8c.2 0 .4 0 .6-.1.2 0 .4-.1.5-.2.1-.1.3-.3.4-.5.1-.2.1-.5.1-.7 0-.4-.1-.8-.4-1.1-.3-.2-.7-.3-1.1-.3-.3 0-.7.1-1 .2-.4.2-.7.4-1 .7 0 .3.1.7.3 1 .1.2.3.4.4.6.2.1.3.3.5.3.2.1.5.2.7.1z',
		p: 'M7.411 18V6.005h3.887c1.474 0 2.429.067 2.881.184.687.185 1.257.57 1.726 1.173.452.603.687 1.374.687 2.329 0 .737-.135 1.357-.403 1.86-.268.502-.603.904-1.021 1.189-.403.284-.821.469-1.257.57-.57.117-1.407.167-2.496.167H9.823V18H7.411zm2.412-9.968v3.401h1.324c.955 0 1.591-.05 1.926-.184.319-.118.57-.319.754-.587.185-.268.268-.57.268-.938 0-.435-.117-.787-.385-1.072a1.607 1.607 0 00-.972-.536c-.284-.05-.87-.084-1.742-.084H9.823z',
		div: 'M6.969 6.005h4.423c1.005 0 1.759.084 2.295.235.703.2 1.306.57 1.809 1.105.503.52.871 1.173 1.14 1.944.267.754.385 1.708.385 2.83 0 .99-.118 1.844-.369 2.547-.302.871-.72 1.592-1.273 2.128-.419.402-.989.72-1.709.955-.536.167-1.24.251-2.144.251H6.969V6.005zm2.43 2.027v7.94h1.808c.67 0 1.156-.033 1.458-.1.402-.1.72-.268.972-.502.268-.235.485-.62.636-1.156.168-.536.251-1.273.251-2.195 0-.938-.083-1.641-.25-2.144-.152-.486-.386-.888-.688-1.156-.285-.285-.67-.469-1.122-.57-.335-.067-.989-.117-1.977-.117H9.398z',
		span: 'M9.357,14.721C9.384,14.961 9.463,15.178 9.594,15.371C9.724,15.565 9.898,15.73 10.113,15.866C10.328,16.002 10.58,16.107 10.869,16.181C11.158,16.254 11.477,16.291 11.826,16.291C12.147,16.291 12.442,16.254 12.709,16.181C12.976,16.107 13.206,16.004 13.4,15.87C13.593,15.736 13.745,15.577 13.854,15.392C13.963,15.206 14.017,15.002 14.017,14.778C14.017,14.593 13.979,14.424 13.903,14.271C13.826,14.119 13.706,13.983 13.543,13.863C13.379,13.743 13.168,13.635 12.909,13.54C12.65,13.444 12.341,13.358 11.981,13.282L10.444,12.955C8.307,12.508 7.239,11.385 7.239,9.586C7.239,9.03 7.346,8.526 7.562,8.074C7.777,7.621 8.081,7.233 8.473,6.909C8.866,6.584 9.34,6.335 9.896,6.16C10.452,5.986 11.071,5.899 11.752,5.899C12.401,5.899 12.998,5.986 13.543,6.16C14.088,6.335 14.56,6.579 14.957,6.892C15.355,7.206 15.669,7.58 15.898,8.016C16.127,8.453 16.249,8.932 16.266,9.456L13.944,9.456C13.916,9.221 13.843,9.009 13.723,8.818C13.603,8.627 13.449,8.463 13.261,8.327C13.073,8.191 12.852,8.086 12.599,8.012C12.345,7.939 12.068,7.902 11.769,7.902C11.458,7.902 11.177,7.936 10.926,8.004C10.676,8.072 10.46,8.17 10.281,8.299C10.101,8.427 9.962,8.582 9.863,8.765C9.765,8.947 9.716,9.15 9.716,9.374C9.716,9.739 9.868,10.033 10.17,10.257C10.473,10.48 10.97,10.666 11.662,10.813L13.085,11.115C13.679,11.241 14.19,11.4 14.618,11.594C15.046,11.787 15.398,12.02 15.673,12.293C15.948,12.565 16.151,12.881 16.282,13.241C16.413,13.601 16.478,14.01 16.478,14.468C16.478,15.062 16.368,15.596 16.147,16.07C15.926,16.545 15.609,16.947 15.195,17.276C14.78,17.606 14.279,17.86 13.69,18.037C13.101,18.214 12.436,18.303 11.695,18.303C10.992,18.303 10.354,18.219 9.782,18.053C9.209,17.887 8.719,17.648 8.31,17.338C7.901,17.027 7.581,16.651 7.349,16.209C7.118,15.768 6.991,15.272 6.969,14.721L9.357,14.721Z',
	};

	if ( ! levelToPath.hasOwnProperty( level ) ) {
		return null;
	}

	let viewBox = '0 0 20 20';

	if ( 'p' === level || 'div' === level || 'span' === level ) {
		viewBox = '0 0 24 24';
	}

	return (
		<SVG
			width="24"
			height="24"
			viewBox={ viewBox }
			xmlns="http://www.w3.org/2000/svg"
		>
			<Path d={ levelToPath[ level ] } />
		</SVG>
	);
}
