<?php

/**
 * GeneratePress Child Theme functions
 */

add_action('after_setup_theme', function () {
    add_theme_support('woocommerce');
    add_theme_support('post-thumbnails');
    add_theme_support('title-tag');
    add_theme_support('html5', ['search-form', 'comment-form', 'gallery']);
    // more supports as needed
});




add_action('wp_enqueue_scripts', function () {
    // Parent style
    wp_enqueue_style('generatepress-style', get_template_directory_uri() . '/style.css');

    // Child style
    wp_enqueue_style('child-style', get_stylesheet_uri(), array('generatepress-style'), wp_get_theme()->get('Version'));

    // Optional custom CSS
    wp_enqueue_style('child-custom-css', get_stylesheet_directory_uri() . '/assets/css/custom.css', array(), '1.0');

    // Optional JS
    wp_enqueue_script('child-custom-js', get_stylesheet_directory_uri() . '/assets/js/custom.js', array('jquery'), '1.0', true);
});

// Include custom woocommerce tweaks 
require_once get_stylesheet_directory() . '/inc/woocommerce-tweaks.php';
// Include custom login branding
require_once get_stylesheet_directory() . '/inc/login-customizations.php';




// Enqueue parent and child styles
add_action('wp_enqueue_scripts', function () {
    wp_enqueue_style('generatepress-style', get_template_directory_uri() . '/style.css');
    wp_enqueue_style('generatepress-child-style', get_stylesheet_directory_uri() . '/style.css', array('generatepress-style'), wp_get_theme()->get('Version'));
});