<?php

/**
 * Custom Login Page Branding
 * Applies logo, link, and title branding on wp-login.php
 */

// Enqueue custom login styles
add_action('login_enqueue_scripts', function () {
?>
<style type="text/css">
body.login div#login h1 a {
    background-image: url('<?php echo get_stylesheet_directory_uri(); ?>/assets/images/login-logo.png');
    background-size: contain;
    background-repeat: no-repeat;
    width: 100%;
    height: 80px;
    padding-bottom: 20px;
}
</style>
<?php
});

// Change the login logo URL to home page
add_filter('login_headerurl', function () {
    return home_url();
});

// Change the login logo hover title
add_filter('login_headertext', function () {
    return get_bloginfo('name');
});